/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.node;

import com.aptana.core.ShellExecutable;
import com.aptana.core.util.IProcessRunner;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.TarUtil;
import com.aptana.core.util.VersionUtil;
import com.aptana.ide.core.io.downloader.DownloadManager;
import com.aptana.js.core.node.INodeJS;
import com.aptana.js.core.node.INodePackageManager;
import com.aptana.js.internal.core.node.Messages;
import com.aptana.js.internal.core.node.NodePackageManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeJS
implements INodeJS {
    private final IPath path;
    private String version;
    private final NodePackageManager fNodePackageManager;

    NodeJS(IPath path) {
        this.path = path;
        this.fNodePackageManager = new NodePackageManager(this);
    }

    @Override
    public INodePackageManager getNPM() {
        return this.fNodePackageManager;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public synchronized String getVersion() {
        if (this.version != null || this.path == null) {
            return this.version;
        }
        this.version = this.doGetNodeVersion();
        return this.version;
    }

    private String doGetNodeVersion() {
        IStatus result = this.createProcessRunner().runInBackground(new String[]{this.path.toOSString(), "-v"});
        return result.getMessage();
    }

    protected IProcessRunner createProcessRunner() {
        return new ProcessRunner();
    }

    @Override
    public boolean exists() {
        return this.path != null && this.path.toFile().isFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IStatus downloadSource(IProgressMonitor monitor) {
        IPath path = this.getSourcePath();
        if (path != null && path.toFile().isDirectory()) {
            return Status.OK_STATUS;
        }
        try {
            String version = this.getVersion();
            if (StringUtil.isEmpty((String)version)) {
                return new Status(4, "com.aptana.js.core", "Can't download source for unknown version of Node.JS");
            }
            String url = MessageFormat.format("http://nodejs.org/dist/{0}/node-{0}.tar.gz", version);
            DownloadManager manager = this.createDownloadManager();
            manager.addURI(URI.create(url));
            IStatus result = manager.start(monitor);
            if (!result.isOK()) return result;
            List files = manager.getContentsLocations();
            Location config = this.getConfigurationLocation();
            if (config.isReadOnly()) {
                config = this.getUserLocation();
            }
            try {
                if (config.lock()) {
                    URL locationURL = config.getDataArea("com.aptana.js.core/node");
                    File locationFile = this.toFile(locationURL);
                    locationFile.mkdirs();
                    IStatus iStatus = this.extractTGZFile(files, locationFile);
                    return iStatus;
                }
                Status status = new Status(4, "com.aptana.js.core", "Unable to acquire write lock on destination: " + config.getURL());
                return status;
            }
            finally {
                config.release();
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (IOException e) {
            return new Status(4, "com.aptana.js.core", e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            return new Status(4, "com.aptana.js.core", e.getMessage(), (Throwable)e);
        }
    }

    protected IStatus extractTGZFile(List<IPath> files, File locationFile) {
        return TarUtil.extractTGZFile((IPath)files.get(0), (IPath)Path.fromOSString((String)locationFile.getAbsolutePath()));
    }

    protected DownloadManager createDownloadManager() {
        return new DownloadManager();
    }

    @Override
    public IStatus runInBackground(String ... args) {
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(this.getPath().toOSString());
        allArgs.addAll(Arrays.asList(args));
        return this.createProcessRunner().runInBackground(ShellExecutable.getEnvironment(), allArgs.toArray(new String[allArgs.size()]));
    }

    @Override
    public IStatus runInBackground(IPath workingDir, Map<String, String> environment, List<String> args) {
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(this.getPath().toOSString());
        allArgs.addAll(args);
        return this.createProcessRunner().runInBackground(workingDir, environment, allArgs.toArray(new String[allArgs.size()]));
    }

    @Override
    public IStatus validate() {
        if (this.path == null) {
            return new Status(4, "com.aptana.js.core", Messages.NodeJSService_NullPathError);
        }
        if (!this.exists()) {
            return new Status(4, "com.aptana.js.core", 1, MessageFormat.format(Messages.NodeJSService_FileDoesntExistError, this.path), null);
        }
        String version = this.getVersion();
        if (version == null) {
            return new Status(4, "com.aptana.js.core", 2, MessageFormat.format(Messages.NodeJSService_CouldntGetVersionError, this.path), null);
        }
        int index = version.indexOf(118);
        if (index != -1) {
            version = version.substring(index + 1);
        }
        if (VersionUtil.compareVersions((String)version, (String)"8.0") >= 0) {
            return Status.OK_STATUS;
        }
        return new Status(4, "com.aptana.js.core", 3, MessageFormat.format(Messages.NodeJSService_InvalidVersionError, this.path, version, "8.0"), null);
    }

    @Override
    public IPath getSourcePath() {
        String value = this.getSourcePathFromPrefs();
        if (!StringUtil.isEmpty((String)value)) {
            return Path.fromOSString((String)value);
        }
        try {
            String version = this.getVersion();
            if (!StringUtil.isEmpty((String)version)) {
                URL locationURL;
                File locationFile;
                Location config = this.getConfigurationLocation();
                if (config.isReadOnly()) {
                    config = this.getUserLocation();
                }
                if ((locationFile = this.toFile(locationURL = config.getDataArea("com.aptana.js.core/node/node-" + version))).isDirectory()) {
                    return Path.fromOSString((String)locationFile.getAbsolutePath());
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected File toFile(URL locationURL) throws URISyntaxException {
        return new File(locationURL.toURI());
    }

    protected Location getUserLocation() {
        return Platform.getUserLocation();
    }

    protected Location getConfigurationLocation() {
        return Platform.getConfigurationLocation();
    }

    protected String getSourcePathFromPrefs() {
        return Platform.getPreferencesService().getString("com.aptana.js.core", "nodejs_source_path", null, null);
    }

    @Override
    public synchronized void nodeJSInstalled() {
        this.version = this.doGetNodeVersion();
    }
}

